; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
[Code]
{ function BrowseForFolder(const Prompt: String; var Directory: String; const NewFolderButton: Boolean): Boolean; }
var
  DataDirPage: TInputDirWizardPage;
  
procedure InitializeWizard;
begin
  { Create the pages }
  DataDirPage := CreateInputDirPage(wpSelectDir,
    'Select nyuqist Directory', 'Where should nyquist/\{runtime,lib,doc,demos\} be installed?',
    'Select the folder in which Setup should create the nyquist directory (usually your home directory), then click Next.',
    False, '');
  DataDirPage.Add('');

  { Set default values, using settings that were stored last time if possible }

  DataDirPage.Values[0] := GetPreviousData('DataDir', '');
end;

procedure RegisterPreviousData(PreviousDataKey: Integer);
var
  UsageMode: String;
begin
  { Store the settings so we can restore them next time }
  SetPreviousData(PreviousDataKey, 'DataDir', DataDirPage.Values[0]);
end;

function ShouldSkipPage(PageID: Integer): Boolean;
begin
  { Skip pages that shouldn't be shown }
  Result := False;
end;

function NextButtonClick(CurPageID: Integer): Boolean;
var
  I: Integer;
begin
  { Validate certain pages before allowing the user to proceed }
  if DataDirPage.Values[0] = '' then
    DataDirPage.Values[0] := 'C:\Users\' + GetUserNameString();
  Result := True;
end;

function UpdateReadyMemo(Space, NewLine, MemoUserInfoInfo, MemoDirInfo, MemoTypeInfo,
  MemoComponentsInfo, MemoGroupInfo, MemoTasksInfo: String): String;
var
  S: String;
begin
  { Fill the 'Ready Memo' with the normal settings and the custom settings }
  S := Space + ExpandConstant('{app}') + ' (nyquist programs location)' + NewLine;
  S := S + NewLine; 
  S := S + Space + DataDirPage.Values[0] + ' (nyquist directory location)' + NewLine;
  S := S + Newline;
  S := S + 'Note: Once installation is complete, do not move or' + NewLine;
  S := S + '      rename the nyquist directory unless you also' + NewLine;
  S := S + '      update the Registry:' + NewLine;
  S := S + '      HKLM Software\CMU\Nyquist\XLISPPATH.' + NewLine;
  Result := S;
end;

function GetDataDir(Param: String): String;
begin
  { Return the selected DataDir }
  Result := DataDirPage.Values[0] + '\nyquist';
end;
[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId=3E29123D-0726-441C-8A38-42836B05F74C
;; apply next 2 lines (x64) if ny.exe is compiled for
;; x86_64, but if nyquist is 32-bit, use the default 
;; values (comment out the next 2 lines). Default puts Nyquist into 
;; Program Files (x86), and sets registry values in Wow6432Node 
;; section where 32-bit Nyquist will find the XLISPPATH.
ArchitecturesInstallIn64BitMode=x64
ArchitecturesAllowed=x64
AppName=NyquistIDE
AppVerName=NyquistIDE 3.16
AppPublisher=Roger B. Dannenberg
AppPublisherURL=http://www.cs.cmu.edu/~music/nyquist
AppSupportURL=http://www.cs.cmu.edu/~music/nyquist
AppUpdatesURL=http://www.cs.cmu.edu/~music/nyquist
DefaultDirName={pf}\Nyquist
DefaultGroupName=Nyquist
LicenseFile=nyqrelide\license.txt
InfoAfterFile=nyqrelide\Readme.txt
OutputDir=setup
OutputBaseFilename=setupnyqiderun
SetupIconFile=sys\win\wingui\nycon.ico
SourceDir=c:\Users\roger\research\nyquist
Compression=lzma
SolidCompression=yes

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "nyqrelide\jnyqide\*"; DestDir: "{app}\jnyqide"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "nyqrelide\jnyqide.bat"; DestDir: "{app}"; Flags: ignoreversion
Source: "nyqrelide\lib\*"; DestDir: "{code:GetDataDir}\lib"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "nyqrelide\doc\*"; DestDir: "{code:GetDataDir}\doc"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "nyqrelide\demos\*"; DestDir: "{code:GetDataDir}\demos"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "nyqrelide\runtime\*"; DestDir: "{code:GetDataDir}\runtime"; Flags: ignoreversion recursesubdirs createallsubdirs
Source: "nyqrelide\*.txt"; DestDir: "{code:GetDataDir}"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Registry]
Root: HKLM; Subkey: "Software\CMU\Nyquist"; ValueType: string; ValueName: "XLISPPATH"; ValueData: "{code:GetDataDir}\runtime,{code:GetDataDir}\lib,{code:GetDataDir}\demos"

[Icons]
Name: "{group}\NyquistIDE"; Filename: "{app}\jnyqide.bat"; WorkingDir: "{app}"
Name: "{commondesktop}\NyquistIDE"; Filename: "{app}\jnyqide.bat"; WorkingDir: "{app}"; Tasks: desktopicon

[Run]
Filename: "{app}\jnyqide.bat"; WorkingDir: "{app}"; Description: "{cm:LaunchProgram,NyquistIDE}"; Flags: shellexec postinstall skipifsilent

