# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.avs.aio import AVSClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAVSVirtualMachinesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AVSClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_list(self, resource_group):
        response = self.client.virtual_machines.list(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            api_version="2024-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_get(self, resource_group):
        response = await self.client.virtual_machines.get(
            resource_group_name=resource_group.name,
            private_cloud_name="str",
            cluster_name="str",
            virtual_machine_id="str",
            api_version="2024-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_machines_begin_restrict_movement(self, resource_group):
        response = await (
            await self.client.virtual_machines.begin_restrict_movement(
                resource_group_name=resource_group.name,
                private_cloud_name="str",
                cluster_name="str",
                virtual_machine_id="str",
                restrict_movement={"restrictMovement": "str"},
                api_version="2024-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
