// SPDX-FileCopyrightText: 2006-2025 Knut Reinert & Freie Universität Berlin
// SPDX-FileCopyrightText: 2016-2025 Knut Reinert & MPI für molekulare Genetik
// SPDX-License-Identifier: BSD-3-Clause

/*!\file
 * \brief Meta-header for the \link utility_char_operations Utility / Builtin Character Operations submodule \endlink.
 * \author Rene Rahn <rene.rahn AT fu-berlin.de>
 * \author Hannes Hauswedell <hannes.hauswedell AT fu-berlin.de>
 */

/*!\defgroup utility_char_operations Builtin Character Operations
 * \brief Provides various operations on character types.
 * \ingroup utility
 * \see utility
 */

#pragma once

#include <seqan3/utility/char_operations/predicate.hpp>
#include <seqan3/utility/char_operations/predicate_detail.hpp>
#include <seqan3/utility/char_operations/pretty_print.hpp>
#include <seqan3/utility/char_operations/transform.hpp>
